#ifndef __ZO_MATRIX__
#define __ZO_MATRIX__

#include <vector>

extern void index_error(void* ctx);

extern void divide_error(void* ctx);

extern void matrix_error(void* ctx);

extern void type_error(void* ctx);

extern void size_error(void* ctx);

extern int math_cal2jul(int yy, int mm, int dd);

extern void math_jul2cal(int *yy, int *mm, int *dd, double jul);

extern int math_jul2tim(int *hh, int *mn, int *sc, double jul);

extern size_t get_array_index(void *ctx, void *obj, size_t n, size_t idx[3]);

extern bool check_rcflag(void *ctx, void *arg);

extern int parse_string(char *buf, std::vector<double> &v, void *ctx);

#endif