#include "matrix-new.h"
#include "matrixtmp-new.h"
#include "api.h"
#include <math.h>
#include <string.h>
#include <stdio.h>

#pragma warning(disable: 4244)

#define DEG2RAD 0.017453292519943 


class matrixRegPrimitive
{
public:
	matrixRegPrimitive(const char* name, int type, void*(*func)(void*,int,void**))
	{
		api_add_primitive(name, type, func);
	}
};

extern void* mat_create_char(void *ctx, int nargs, void** args);
extern void* mat_create_uchar(void *ctx, int nargs, void** args);
extern void* mat_create_short(void *ctx, int nargs, void** args);
extern void* mat_create_ushort(void *ctx, int nargs, void** args);
extern void* mat_create_int(void *ctx, int nargs, void** args);
extern void* mat_create_uint(void *ctx, int nargs, void** args);
extern void* mat_create_float(void *ctx, int nargs, void** args);
extern void* mat_create_double(void *ctx, int nargs, void** args);

void* mat_create_type(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	if (api_is_number(args[0])) {
		zoMatrixTmp<double> *P = new zoMatrixTmp<double>(MAT_DOUBLE);
		P->resize(1, nargs);
		for (int i = 0; i < nargs; i++) (*P)(i) = api_get_number(ctx, args[i]);
		return api_create_user(ctx, P, mat_opfunc_double, mat_destroy_double, MAT_DOUBLE);
	}
	const char* s = api_get_string(ctx, args[0]);
	if (strcmp(s, "double") == 0) {
		return mat_create_double(ctx, nargs-1, args+1);
	}
	if (strcmp(s, "float") == 0) {
		return mat_create_float(ctx, nargs-1, args+1);
	}
	if (strcmp(s, "int") == 0) {
		return mat_create_int(ctx, nargs-1, args+1);
	}
	if (strcmp(s, "uint") == 0) {
		return mat_create_uint(ctx, nargs-1, args+1);
	}
	if (strcmp(s, "short") == 0) {
		return mat_create_short(ctx, nargs-1, args+1);
	}
	if (strcmp(s, "ushort") == 0) {
		return mat_create_ushort(ctx, nargs-1, args+1);
	}
	if (strcmp(s, "char") == 0) {
		return mat_create_char(ctx, nargs-1, args+1);
	}
	if (strcmp(s, "uchar") == 0) {
		return mat_create_uchar(ctx, nargs-1, args+1);
	}
	api_input_error(ctx);
	return 0;
}
static matrixRegPrimitive mat_reg_create("matrix", 0, mat_create_type);

/////////////////////////////////////////////////////////////////////
/*
int math_cal2jul(int yy, int mm, int dd)
{
	yy -= mm < 3;
	mm += 12 * (mm < 3);
	int a = 365.25 * (yy + 4716),
		b = 30.6001 * (mm + 1);
	return a + b + dd - 2416556;
}

double math_jul2cal(int *yy, int *mm, int *dd, double jul)
{
	int a = jul + 2415032,
		b = a + 1524,
		c = (double(b) - 122.1) / 365.25,
		d = 365.25 * c,
		e = double(b - d) / 30.6001,
		f = 30.6001 * e;

	*dd = b - d - f;
	*mm = e - 1 - 12 * (e > 13);
	*yy = c - 4715 - (*mm > 2);

	return jul - floor(jul);
}
*/
int math_cal2jul(int yy, int mm, int dd)
{
	// 2012.10
	// http://en.wikipedia.org/wiki/Julian_day
	int a = (14 - mm) / 12;
	yy += 4800 - a;
	mm += 12*a - 3;
	dd += (153*mm + 2)/5 + 365*yy + yy/4 - yy/100 + yy/400 - 32045;
	// match excel by adding 2415019
	// excel has problem for treating 1900 as a leap year
	// so the match show one day difference before 1900.3.1
	dd -= 2415019;
	return dd;
}

void math_jul2cal(int *yy, int *mm, int *dd, real_t jul)
{
	jul = floor(jul);
	// match excel by adding 2415019
	// excel has problem for treating 1900 as a leap year
	// so the match show one day difference before 1900.3.1
	jul += 2415019;
	// http://en.wikipedia.org/wiki/Julian_day
	int j = int(jul + 0.5) + 32044;
	int g  = j/146097;
	int dg = j%146097;
	int c  = (dg/36524 + 1)*3/4;
	int dc = dg - c*36524;
	int b  = dc/1461;
	int db = dc%1461;
	int a  = (db/365 + 1)*3/4;
	int da = db - a*365;
	int y  = g*400 + c*100 + b*4 + a;
	int m  = (da*5 + 308)/153 - 2;
	int d  = da - (m + 4)*153/5 + 122;
	*yy = y - 4800 + (m + 2)/12;
	*mm = (m + 2)%12 + 1;
	*dd = d + 1;
}

int math_jul2tim(int *hh, int *mn, int *sc, double jul)
{
	// this constant is for solving double precision problem (may be OS or compiler dependent)
	const real_t sd = 1.0e-10;
	if (jul >= 1.0) jul -= floor(jul); 
	if (jul <= 0.0) {
		*hh = 0; *mn = 0; *sc = 0;
		return 0;
	}
	if (jul + sd < 1.0) jul += sd; 
	jul *= 24.0;
	*hh = jul;
	jul = (jul - *hh) * 60.0;
	*mn = jul;
	jul = (jul - *mn) * 60.0;
	*sc = jul;
	return (jul - *sc) * 1000;
}

/////////////////////////////////////////////////////////////////////

void index_error(void* ctx)
{
	api_runtime_error(ctx, "bad matrix index or dimension");
}

void divide_error(void* ctx)
{
	api_runtime_error(ctx, "divided by zero");
}

void type_error(void* ctx)
{
	api_runtime_error(ctx, "unexpected matrix type/dimension");
}

void matrix_error(void* ctx)
{
	api_runtime_error(ctx, "matrix or number expected");
}

void size_error(void* ctx)
{
	api_runtime_error(ctx, "bad row/column size");
}

size_t get_array_index(void *ctx, void *obj, size_t n, size_t idx[3])
{
	if (api_is_integer(obj)) {
		idx[0] = api_get_integer(ctx, obj);
		idx[1] = idx[0];
		idx[2] = 1;
		if (idx[0] < 0 || idx[0] >= n) index_error(ctx);
		return 1;
	}
	if (api_is_null(obj)) {
		idx[0] = 0;
		idx[1] = n - 1;
		idx[2] = 1;
		return n;
	}
	if (!api_is_array(obj)) {
		api_runtime_error(ctx, "matrix index must be integer, null, array (range), or char type matrix"); 
	}
	void *a = api_get_array_object(ctx, obj, "0");
	if (api_is_null(a)) {
		idx[0] = 0;
	}
	else {
		idx[0] = api_get_integer(ctx, a);
	}
	a = api_get_array_object(ctx, obj, "1");
	if (api_is_null(a)) {
		idx[1] = n - 1;
	}
	else {
		idx[1] = api_get_integer(ctx, a);
	}
	if (api_get_array_size(ctx, obj) > 2) {
		idx[2] = api_get_integer(ctx, api_get_array_object(ctx, obj, "2"));
	}
	else {
		idx[2] = 1;
	}
	if (idx[0] < 0 || idx[1] < idx[0] || idx[2] <= 0 || idx[1] >= n) {
		api_runtime_error(ctx, "bad index in D[?:?:?]"); 
	}
	return (idx[1]-idx[0])/idx[2]+1;
}

bool check_rcflag(void *ctx, void *arg)
{
	const char* c = api_get_string(ctx, arg);
	if (c[0] == 'c' || c[0] == 'C') return true;
	if (c[0] == 'r' || c[0] == 'R') return false;
	api_runtime_error(ctx, "bad row/column flag");
	return false;
}

