#include "matrixtmp.h"
#include "matrix.h"
#include "api.h"
#include "clipping.h"

#include <vector>

using namespace std;

#define DEG_TO_RAD		0.017453292519943 


void* geo_clip(void *ctx, int nargs, void** args)
{
	if (nargs < 5) api_input_error(ctx);
	zoDOUBLE *me = reinterpret_cast<zoDOUBLE*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->ncol() < 2 || me->nrow() < 2) api_input_error(ctx);
	rect_t rect = { api_get_number(ctx, args[1]),
					api_get_number(ctx, args[2]),
					api_get_number(ctx, args[3]),
					api_get_number(ctx, args[4]) };

	zoDOUBLE x, y;
	me->getcol(x, 0);
	me->getcol(y, 1);
	vector<xy_t> out;
	clip_rectangle(out, x.ptr(), y.ptr(), me->nrow(), rect);
	if (!out.empty()) {
		zoDOUBLE *p = new zoDOUBLE;
		p->resize(out.size(), 2);
		for (int i = 0; i < out.size(); i++) {
			(*p)(i,0) = out[i].x;
			(*p)(i,1) = out[i].y;
		}
		return api_create_user(ctx, p, mat_opfunc_DOUBLE, mat_destroy_DOUBLE, MAT_DOUBLE);
	}
	return 0;
}
static zsRegPrimitive geo1("clip", MAT_DOUBLE, geo_clip);

// http://www.ecse.rpi.edu/Homepages/wrf/Research/Short_Notes/pnpoly.html
// W. Randolph Franklin
//
int point_in_polygon(const real_t *xp, const real_t *yp, int n, real_t x, real_t y)
{
	int i, j, c = 0;
	for (i = 0, j = n-1; i < n; j = i++) {
		if ((((yp[i] <= y) && (y < yp[j])) ||
			 ((yp[j] <= y) && (y < yp[i]))) &&
			(x < (xp[j] - xp[i]) * (y - yp[i]) / (yp[j] - yp[i]) + xp[i]))
		c = !c;
	}
	return c;
}

void* geo_inside(void *ctx, int nargs, void** args)
{
	if (nargs < 3) api_input_error(ctx);
	zoDOUBLE *me = reinterpret_cast<zoDOUBLE*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->nrow() < 3 || me->ncol() < 2) api_input_error(ctx);
	zoDOUBLE x, y;
	me->getcol(x, 0);
	me->getcol(y, 1);
	if (api_get_type(args[1]) == MAT_DOUBLE && api_get_type(args[2]) == MAT_DOUBLE) {
		zoDOUBLE *u = reinterpret_cast<zoDOUBLE*>(api_get_ptr(ctx, args[1]));
		zoDOUBLE *v = reinterpret_cast<zoDOUBLE*>(api_get_ptr(ctx, args[2]));
		if (u->ndat() != v->ndat()) api_input_error(ctx);
		zoCHAR *c = new zoCHAR;
		c->resize(u->ndat(), 1);
		for (int i = 0; i < u->ndat(); i++) (*c)(i) = point_in_polygon(x.ptr(), y.ptr(), x.ndat(), (*u)(i), (*v)(i));
		return api_create_user(ctx, c, mat_opfunc_CHAR, mat_destroy_CHAR, MAT_CHAR);
	}
	double u = api_get_number(ctx, args[1]);
	double v = api_get_number(ctx, args[2]);
	int n = point_in_polygon(x.ptr(), y.ptr(), x.ndat(), u, v);
	return api_create_integer(ctx, n);
}
static zsRegPrimitive geo2("inside", MAT_DOUBLE, geo_inside);


void* geo_area(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	zoDOUBLE *me = reinterpret_cast<zoDOUBLE*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->nrow() < 3 || me->ncol() < 2) api_input_error(ctx);
	double a = 0;
	int i, n = me->nrow();
	double x0 = (*me)(0,0);
	double y0 = (*me)(0,1);
	if (x0 == (*me)(n-1,0) && y0 == (*me)(n-1,1)) {
		n--;
		if (n < 3) api_input_error(ctx);
	}
	double x1 = (*me)(1,0) - x0;
	double y1 = (*me)(1,1) - y0;
	for (i = 2; i < n; i++) {
		double x2 = (*me)(i,0) - x0;
		double y2 = (*me)(i,1) - y0;
		a += x1*y2 - x2*y1;
		x1 = x2;
		y1 = y2;
	}
	return api_create_real(ctx, 0.5*a);
}
static zsRegPrimitive geo3("area", MAT_DOUBLE, geo_area);


void* geo_triangulate(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	zoDOUBLE *me = reinterpret_cast<zoDOUBLE*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->nrow() < 3 || me->ncol() < 2) api_input_error(ctx);
	double refine = 0;
	if (nargs > 1) refine = api_get_number(ctx, args[1]);
	bool sphere = false;
	if (nargs > 2) refine = api_get_integer(ctx, args[2]) != 0;
	zoDOUBLE *p = new zoDOUBLE;
	if (me->nrow() == 3) {
		p->resize(3, 2);
		(*p)(0,0) = (*me)(0,0);
		(*p)(0,1) = (*me)(0,1);
		(*p)(1,0) = (*me)(1,0);
		(*p)(1,1) = (*me)(1,1);
		(*p)(2,0) = (*me)(2,0);
		(*p)(2,1) = (*me)(2,1);
		return api_create_user(ctx, p, mat_opfunc_DOUBLE, mat_destroy_DOUBLE, MAT_DOUBLE);
	}
	zoDOUBLE x, y;
	me->getcol(x, 0);
	me->getcol(y, 1);
	vector<xy_t> ret;
	ear_cut_triangulate(ret, x.ptr(), y.ptr(), x.ndat(), refine, sphere);
	p->resize(ret.size(), 2);
	for (int i = 0; i < ret.size(); i++) {
		(*p)(i,0) = ret[i].x;
		(*p)(i,1) = ret[i].y;
	}
	return api_create_user(ctx, p, mat_opfunc_DOUBLE, mat_destroy_DOUBLE, MAT_DOUBLE);
}
static zsRegPrimitive geo4("triangulate", MAT_DOUBLE, geo_triangulate);


