#include "matrixtmp-new.h"
#include "matrix-new.h"
#include "api.h"
#include "clipping.h"

#include <vector>

using namespace std;

#define DEG_TO_RAD		0.017453292519943 


void* geo_clip(void *ctx, int nargs, void** args)
{
	if (nargs < 5) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->ncol() < 2 || me->nrow() < 2) api_input_error(ctx);
	rect_t rect = { api_get_number(ctx, args[1]),
					api_get_number(ctx, args[2]),
					api_get_number(ctx, args[3]),
					api_get_number(ctx, args[4]) };

	zoMatrixTmp<double> x, y;
	x.getcol(*me, 0);
	y.getcol(*me, 1);
	vector<xy_t> out;
	clip_rectangle(out, x.ptr(), y.ptr(), me->nrow(), rect);
	if (!out.empty()) {
		zoMatrixTmp<double> *p = new zoMatrixTmp<double>;
		p->resize(out.size(), 2);
		for (int i = 0; i < out.size(); i++) {
			(*p)(i,0) = out[i].x;
			(*p)(i,1) = out[i].y;
		}
		return api_create_user(ctx, p, mat_opfunc_double, mat_destroy_double, MAT_DOUBLE);
	}
	return 0;
}

void* geo_inside(void *ctx, int nargs, void** args)
{
	if (nargs < 3) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->nrow() < 3 || me->ncol() < 2) api_input_error(ctx);
	zoMatrixTmp<double> x, y;
	x.getcol(*me, 0);
	y.getcol(*me, 1);
	if (api_get_type(args[1]) == MAT_DOUBLE && api_get_type(args[2]) == MAT_DOUBLE) {
		zoMatrixTmp<double> *u = reinterpret_cast<zoMatrixTmp<double>*>(api_get_ptr(ctx, args[1]));
		zoMatrixTmp<double> *v = reinterpret_cast<zoMatrixTmp<double>*>(api_get_ptr(ctx, args[2]));
		if (u->ndat() != v->ndat()) api_input_error(ctx);
		zoMatrixTmp<char> *c = new zoMatrixTmp<char>;
		c->resize(u->ndat(), 1);
		for (int i = 0; i < u->ndat(); i++) (*c)(i) = point_in_polygon(x.ptr(), y.ptr(), x.ndat(), (*u)(i), (*v)(i));
		return api_create_user(ctx, c, mat_opfunc_char, mat_destroy_char, MAT_CHAR);
	}
	double u = api_get_number(ctx, args[1]);
	double v = api_get_number(ctx, args[2]);
	int n = point_in_polygon(x.ptr(), y.ptr(), x.ndat(), u, v);
	return api_create_integer(ctx, n);
}


void* geo_area(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->nrow() < 3 || me->ncol() < 2) api_input_error(ctx);
	double a = 0;
	int i, n = me->nrow();
	double x0 = (*me)(0,0);
	double y0 = (*me)(0,1);
	if (x0 == (*me)(n-1,0) && y0 == (*me)(n-1,1)) {
		n--;
		if (n < 3) api_input_error(ctx);
	}
	double x1 = (*me)(1,0) - x0;
	double y1 = (*me)(1,1) - y0;
	for (i = 2; i < n; i++) {
		double x2 = (*me)(i,0) - x0;
		double y2 = (*me)(i,1) - y0;
		a += x1*y2 - x2*y1;
		x1 = x2;
		y1 = y2;
	}
	return api_create_real(ctx, 0.5*a);
}


void* geo_triangulate(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	if (me->nrow() < 3 || me->ncol() < 2) api_input_error(ctx);
	double refine = 0;
	if (nargs > 1) refine = api_get_number(ctx, args[1]);
	bool sphere = false;
	if (nargs > 2) refine = api_get_integer(ctx, args[2]) != 0;
	zoMatrixTmp<double> *p = new zoMatrixTmp<double>;
	if (me->nrow() == 3) {
		p->resize(3, 2);
		(*p)(0,0) = (*me)(0,0);
		(*p)(0,1) = (*me)(0,1);
		(*p)(1,0) = (*me)(1,0);
		(*p)(1,1) = (*me)(1,1);
		(*p)(2,0) = (*me)(2,0);
		(*p)(2,1) = (*me)(2,1);
		return api_create_user(ctx, p, mat_opfunc_double, mat_destroy_double, MAT_DOUBLE);
	}
	zoMatrixTmp<double> x, y;
	x.getcol(*me, 0);
	y.getcol(*me, 1);
	vector<xy_t> ret;
	ear_cut_triangulate(ret, x.ptr(), y.ptr(), x.ndat(), refine, sphere);
	p->resize(ret.size(), 2);
	for (int i = 0; i < ret.size(); i++) {
		(*p)(i,0) = ret[i].x;
		(*p)(i,1) = ret[i].y;
	}
	return api_create_user(ctx, p, mat_opfunc_double, mat_destroy_double, MAT_DOUBLE);
}


class zsRegPrimitive
{
public:
	zsRegPrimitive()
	{
		api_add_primitive("clip", MAT_DOUBLE, geo_clip);
		api_add_primitive("inside", MAT_DOUBLE, geo_inside);
		api_add_primitive("area", MAT_DOUBLE, geo_area);
		api_add_primitive("triangulate", MAT_DOUBLE, geo_triangulate);
	}
};

static zsRegPrimitive regster_geometry_primitve;

