#ifndef __CLIPPING_H__
#define __CLIPPING_H__

#include <vector>

typedef double real_t;
typedef struct { real_t x, y; } xy_t;
typedef struct { real_t x, y, z; } xyz_t;
typedef struct { real_t x, y, w, h; } rect_t;

void clip_rectangle(std::vector<xy_t>& out, const real_t *x, const real_t *y, int n, const rect_t& rect);

int line_intersect(real_t out[2], const real_t p1[2], const real_t p2[2], const real_t q1[2], const real_t q2[2]);

int point_in_polygon(const real_t *xp, const real_t *yp, int n, real_t x, real_t y);

real_t polygon_area(const real_t *x, const real_t *y, int n);

void ear_cut_triangulate(std::vector<xy_t>& out, const real_t *x, const real_t *y, int n, real_t refine, bool sphere);

#endif

